# XXX 模块使用说明

**说明**：此文档为写作模板，文中所有内容均为写作示例，请根据实际情况编写模块文档。

## 模块介绍

测试 DolphinDB 数据库性能时，往往需要在短时间内写入大量结构规范、分布可控的测试数据。为满足这一需求，DolphinDB 开发了 MockData 模块。该模块用于快速模拟生成各类金融业务数据及对应的库表结构，避免对真实业务数据的依赖，提高测试和验证工作的效率与可重复性。

目前，MockData 模块支持多种常见金融数据类型，包括股票数据（快照、逐笔委托、逐笔成交等）、期权数据、期货数据、银行间债券数据以及因子库数据。该模块主要适用于性能和压力测试、功能验证与回归测试、方案演示，以及开发调试等场景。

## 第三方模块/插件介绍

**说明**：如无依赖的模块/插件，可删除此章节。

## 安装模块

### 版本要求

本模块基于 DolphinDB Server 2.00.13 开发，请在 2.00.13 及以上版本的 Server 中使用该模块。

### 安装步骤

1. 在 DolphinDB 客户端中使用 `listRemoteModules` 函数查询可用的模块。

   ```
   login("admin", "123456")
   listRemoteModules()
   ```

2. 使用 `installModule` 函数安装模块。

   ```
   installModule("MockData")
   ```

3. 使用 use 关键字加载模块。

   ```
   use MockData
   ```

## 接口介绍

**说明**：一般可直接使用接口名调用接口，如 `stockSnapshot(tradeDate, securityNumber)`；若不同模块中含有相同名称的接口，则必须使用接口的完整路径进行调用，如 `MockData::stockSnapshot(tradeDate, securityNumber)`。

### stockSnapshot

**语法**

stockSnapshot(tradeDate, securityNumber)

**详情**

创建一天的 Level-2 快照模拟数据，并以表的数据形式返回。交易日期通过 *tradeDate* 指定，股票标的数量通过 *securityNumber* 指定。

**参数**

**tradeDate**：DATE 类型的标量，表示快照数据的日期。

**securityNumber**：INT 类型的标量，表示股票标的数量。

**返回值**

一个表对象。

**例子**

```
snapshotData = stockSnapshot(tradeDate=2020.01.06, securityNumber=10)
```

返回一个 snapshotData 表：

**说明**：此处仅提供一个接口说明作为示例，请根据实际情况并按照以上格式为每一个接口提供详细的说明。

## 使用示例

先使用 stockSnapShotPT 接口生成用于存放股票快照数据的表，再使用 stockSnapshot 接口生成股票快照数据，最后将生成的快照数据写入表。

```
use MockData

t = stockSnapShotPT("dfs://merge_TB", "merge_snapshotTB")
snapshotData = stockSnapshot(tradeDate=2020.01.06, securityNumber=10)

t.append!(snapshotData)
```

## 版本说明

模块首次发布。（**1.0.0**）

**新功能**

新增函数 futuresPT 和 optionsPT，用于生成期货和期权数据。**（1.0.4）**

**功能优化**

提升模拟数据生成的速度。（**1.0.1**）

**故障修复**

修复使用 stockSnapshot 函数后生成数据失败的问题。（**1.0.1**）

## 常见问题

**说明**：如无常见问题，可删除此章节。

### 查询数据库时报错：The query is too large

**问题描述**

执行查询数据库表的代码后可能会出现查询分区数量过多的问题，示例代码如下：

```
temp = select top 100 * from loadTable(db_path, tb_name)
```

报出如下错误：

```
The number of partitions [880900] relevant to the query is too large. 
	Please add more specific filtering conditions on partition columns in WHERE clause, 
	or consider changing the value of the configuration parameter maxPartitionNumPerQuery.
```

**解决方法**

- 方法一：查询时通过 WHERE 语句减少查询涉及的分区数量。
- 方法二：增大单个查询语句可查找的最大分区数，系统默认值是 65536，可以通过参数 *maxPartitionNumPerQuery* 进行配置并在重启后生效。

## 附录

**说明**：如无附录，可删除此章节。